# Security Policy

## Supported Versions

This section lists the versions of the DHT11 library that are currently receiving updates.

| Version | Supported          |
| ------- | ------------------ |
| 2.0.x   | :white_check_mark: |
| < 2.0   | :x:                |

## Reporting a Vulnerability

The DHT11 Arduino library primarily facilitates interaction with the DHT11 temperature and humidity sensor. While the risk associated with this is minimal, maintaining a secure and reliable codebase remains a priority.

If you believe you've found a security vulnerability in the DHT11 library, please follow the steps below:

1. **Do Not Open a Public Issue:** To ensure the vulnerability doesn't become public knowledge and put users at risk, refrain from opening an issue on the public GitHub repository.
   
2. **Contact the Maintainer:** Send a detailed description of the vulnerability directly to [dhrubasaha@outlook.com](mailto:dhrubasaha@outlook.com). Please provide as much information as possible to help understand the scope and severity of the potential issue.

3. **Response Time:** I aim to acknowledge and respond to your report within 7 days. In the response, you can expect an evaluation of the issue and an estimated timeline for a fix if deemed necessary.

4. **Disclosure:** Once the vulnerability has been addressed, I'll work with you to publicly disclose the issue in a responsible manner, ensuring the community is informed and can take appropriate actions.

Your efforts to responsibly disclose your findings are sincerely appreciated and will be acknowledged.
