# Contributing to DHT11 Arduino Library

Thank you for considering contributing to the DHT11 Arduino Library. It's community members like you that enhance the usefulness of this library.

## Code of Conduct

I'm committed to fostering a welcoming and open environment. All contributors are expected to adhere to the [DHT11 Arduino Library Code of Conduct](CODE_OF_CONDUCT.md). If you encounter unacceptable behavior, please report it to dhrubasaha@outlook.com.

## How Can I Contribute?

### Reporting Bugs

- **Ensure the bug wasn't previously reported** by searching on GitHub under [Issues](https://github.com/dhrubasaha08/DHT11/issues).
- If you can't find an existing issue addressing the problem, [open a new one](https://github.com/dhrubasaha08/DHT11/issues/new).

### Suggesting Enhancements

Have an idea for an enhancement or a new feature? Please create an issue labeled `enhancement`.

### Pull Requests

1. Fork the repository.
2. Create a new branch (`git checkout -b new-feature`).
3. Commit your changes (`git commit -am 'Add a new feature'`).
4. Push the branch (`git push origin new-feature`).
5. Submit a Pull Request.

## Styleguides

### Git Commit Messages

- Use present tense ("Add feature" not "Added feature").
- Start with a capital letter.
- Limit the first line to 72 characters or fewer.

### Code Styleguide

Stick to the coding conventions evident in the project.

## Additional Notes

### Issue and Pull Request Labels

Possible labels for issues or PRs include:

- `bug` - For bug-related issues.
- `enhancement` - For enhancements or new features.
- `documentation` - For documentation-related issues.
